﻿<%@ Page language="c#" CodePage="65001" AutoEventWireup="false" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>
<script runat="server">
  void PozycjeDR_OnBeforeRow(Object sender, EventArgs args) {
    ParagrafItem pi = (ParagrafItem)PozycjeDR.CurrentRow;
    if (pi.Plan == 0)
      PozycjeDR_PL.Visible = false;
    if (pi.Zaangazowanie == 0)
      PozycjeDR_ZA.Visible = false;
    if (pi.Wykonanie == 0)
      PozycjeDR_WW.Visible = false;
    if (pi.Zobowiazania == 0)
      PozycjeDR_ZO.Visible = false;            
  }
  
    void OnContextLoad(Object sender, EventArgs args){
			Soneta.Business.View kontaPlanu = KsiegaModule.GetInstance(Param).Konta.WgOkres[Param.Okres].CreateView();
				kontaPlanu.Condition &= new FieldCondition.Equal("Poziom",Param.KontoPlanu.Poziom+2);
				kontaPlanu.Condition &= new FieldCondition.Like("Symbol",Param.FiltrKontaPlanu());
				
				ArrayList arr = new ArrayList();
				foreach(KontoBase k in kontaPlanu){
          ParagrafItem pi = new ParagrafItem(Param, k);
          if(pi.Visible)
					  arr.Add(pi);
				}
				PozycjeDR.DataSource = arr;
    }
   
		Params param = null;
		[Context]
    public Params Param{
			get{ return param; }
			set{ param = value; }
    }
    
    public class ParagrafItem {
			readonly Params Param = null;
			readonly KontoBase KontoPlanu = null;
			readonly string dzial = "";
			readonly string rozdzial = "";			
			readonly string paragraf = "";
			readonly decimal plan = 0m;									
			readonly decimal wykonanie = 0m;
      readonly decimal zaangazowanie = 0m;
			readonly decimal koszty = 0m;
			readonly decimal naleznosciBO = 0m;
			readonly decimal naleznosci = 0m;
			readonly decimal zobowiazaniaBO = 0m;
			readonly decimal zobowiazania = 0m;				
			readonly bool visible = false;															

			public ParagrafItem(Params param, KontoBase kontoPlanu){
				this.Param = param;
				this.KontoPlanu = kontoPlanu;

				paragraf = KontoPlanu.Segment;
				rozdzial = KontoPlanu.Nadrzedne.Segment;
				dzial = Soneta.Core.Tools.Left(rozdzial,3);
				
				ObrotyKontaWorker okw = new ObrotyKontaWorker();
				ObrotyKontaWorker.Params par = new ObrotyKontaWorker.Params(null);

				Konta konta = KsiegaModule.GetInstance(Param).Konta;

				par.Bufor = Param.Bufor;
				par.Typ = TypObrotu.Księgowy;				
				par.Okres = new FromTo(Param.Okres.Okres.From,Param.Data);
				okw.Param = par;
				

				okw.Konto = KontoPlanu;
				plan = System.Math.Abs(okw.PerSaldo);
        if(plan!=0)
				  visible = true;

				
				KontoBase kontoWykonania = konta.WgOkres[Param.Okres,string.Format("{0}-{1}-{2}",Param.KontoWykonania.Symbol,Rozdzial,Paragraf)];				
				
				if(kontoWykonania!=null){

					okw.Konto = kontoWykonania;
					wykonanie = - okw.PerSaldo;

				}

				KontoBase kontoZaangazowania = konta.WgOkres[Param.Okres, string.Format("{0}-{1}-{2}", Param.KontoZaangazowania.Symbol, Rozdzial, Paragraf)];
				if (kontoZaangazowania != null)
				{
					okw.Konto = kontoZaangazowania;
					zaangazowanie = System.Math.Abs(okw.ObrotyNMa);
				}

				/*if (Param.KontaKosztow != "") {
					KontoBase kontoKosztow = null;
					foreach (string symbol in Param.KontaKosztow.Split(';')) {
						kontoKosztow = konta.WgOkres[Param.Okres, string.Format("{0}-{1}-{2}", symbol, Rozdzial, Paragraf)];
						if (kontoKosztow == null)
							continue;
						
						okw.Konto = kontoKosztow;
						koszty += okw.SaldoWn;
			
					}
				}*/

				/*if (Param.KontaNaleznosci != "") {
					KontoBase kontoNaleznosci = null;
					foreach (string symbol in Param.KontaNaleznosci.Split(';')) {
						kontoNaleznosci = konta.WgOkres[Param.Okres, string.Format("{0}-{1}-{2}", symbol, Rozdzial, Paragraf)];
						if (kontoNaleznosci == null)
							continue;

						okw.Konto = kontoNaleznosci;
						naleznosciBO += okw.BOWn;
						naleznosci += okw.SaldoWn;
					}
				}*/

				if (Param.KontaZobowiazan != "") {
					KontoBase kontoZobowiazan = null;
					foreach (string symbol in Param.KontaZobowiazan.Split(';')) {
						kontoZobowiazan = konta.WgOkres[Param.Okres, string.Format("{0}-{1}-{2}", symbol, Rozdzial, Paragraf)];
						if (kontoZobowiazan == null)
							continue;

						okw.Konto = kontoZobowiazan;
						zobowiazaniaBO += okw.BOMa;
						zobowiazania += okw.SaldoMa;
					}
				}								
				
				
			}
			
    
			public string Dzial{
				get{ return dzial; }
			}
			
			public string Rozdzial{
				get{ return rozdzial; }
			}
			
			public string Paragraf{
				get{ return paragraf; }
			}

      public string P4 {
        get { return paragraf.Length>=4 ? paragraf.Substring(3,1) : ""; }
      }      
			
			public decimal Plan{
				get{ return plan;}
			}
			
			public decimal Wykonanie{
				get{ return wykonanie;}
			}
			
			public decimal Pozostalo{
				get{ return plan - wykonanie;}
			}			
			
			public decimal Procent{
				get{ return (plan!=0) ? (wykonanie/plan)*100 : 0m;}
			}

            public decimal Zaangazowanie
            {
                get { return zaangazowanie; }
            }        

            public decimal ProcentZaangazowania
            {
                get { return (plan != 0) ? (zaangazowanie / plan) * 100 : 0m; }
            }					        
			
			public bool Visible{
				get{ return visible;}
			}

			public decimal Koszty {
				get { return koszty; }
			}

			public decimal NaleznosciBO {
				get { return naleznosciBO; }
			}

			public decimal Naleznosci {
				get { return naleznosci; }
			}											
		
			public decimal ZobowiazaniaBO {
				get { return zobowiazaniaBO; }
			}

			public decimal Zobowiazania {
				get { return zobowiazania; }
			}											
    }				
    
    public class Params : ContextBase{
			
			
			public Params(Context cx): base(cx){
				okres = (OkresObrachunkowy)cx[typeof(OkresObrachunkowy)];
				if (cx.Contains(typeof(Dziennik.Params)))
					data = ((Dziennik.Params)cx[typeof(Dziennik.Params)]).Zakres.To;
				Konta konta = KsiegaModule.GetInstance(this).Konta;
				kontoPlanu = konta.WgOkres[okres, "980"];
				kontoWykonania = konta.WgOkres[okres, "130"];
				KontoZaangazowania = konta.WgOkres[okres, "998"];
				//paragraf = "4300";
			}
			
			OkresObrachunkowy okres = null;
			[Caption("Okres")]
			[Priority(1)]
			public OkresObrachunkowy Okres{
				get{ return okres;}
			}

			Date data = Date.Today;
			[Caption("Data")]
			[Priority(2)]
			public Date Data {
				get { return data; }
				set {
					if (value == Date.Empty)
						throw new Exception("Należy ustawić datę");
					if (Okres.Okres.From > value)
						throw new Exception("Data wcześniejsza o daty ropoczęcia okresu.");
					data = value;
				}
			}			
			
			bool bufor = true;
			[Caption("Uwzględniaj bufor")]
			[Priority(3)]			
			public bool Bufor{
				get{ return bufor; }
				set{ bufor = value; }
			}
			
			LookupInfo GetListKonto(){
				return new LookupInfo(KsiegaModule.GetInstance(Session).Konta.WgOkres[Okres]);
			}
			
			string FiltrKonta(KontoBase konto){
        return string.Format("{0}-{1}-{2}", konto.Symbol, (rozdzial == "") ? "*" : rozdzial, (paragraf == "") ? "*" : paragraf);
			}
						
			
			KontoBase kontoPlanu = null;
			[Caption("Konto planu")]
			[Priority(4)]			
			public KontoBase KontoPlanu{
				get{ return kontoPlanu; }
				set{ kontoPlanu = value; }
			}						
			
			public LookupInfo GetListKontoPlanu(){
				return GetListKonto();
			}
			
			public string FiltrKontaPlanu(){
				return FiltrKonta(KontoPlanu);
			}
			
			KontoBase kontoWykonania = null;
			[Caption("Konto wykonania")]
			[Priority(5)]			
			public KontoBase KontoWykonania{
				get{ return kontoWykonania; }
				set{ kontoWykonania = value; }
			}									
			
			public LookupInfo GetListKontoWykonania(){
				return GetListKonto();
			}			
			
			public string FiltrKontaWykonania(){
				return FiltrKonta(KontoWykonania);
			}

            KontoBase kontoZaangazowania = null;
            [Caption("Konto zaangażowania")]
            [Priority(6)]
            public KontoBase KontoZaangazowania
            {
                get { return kontoZaangazowania; }
                set { kontoZaangazowania = value; }
            }

            public LookupInfo GetListKontoZaangazowania()
            {
                return GetListKonto();
            }

            public string FiltrKontaZaangazowania()
            {
                return FiltrKonta(KontoZaangazowania);
            }			        
			
			//string dzial = "";
			//[Caption("Dział")]
			//[Priority(6)]			
			//public string Dzial{
				//get{ return dzial; }
				//set{ dzial = value; }
			//}		

      string kontaZobowiazan = "";
      [Caption("Konta zobowiązań")]
      [Priority(7)]
      public string KontaZobowiazan {
        get { return kontaZobowiazan; }
        set { kontaZobowiazan = value; }
      }														      

			string kontaWymagalne = "";
			/*[Caption("Konta zob. wymagalnych")]
			[Priority(8)]
      public string KontaWymagalne {
        get { return kontaWymagalne; }
        set { kontaWymagalne = value; }
			}*/

			string kontaNaleznosci = "";
			/*[Caption("Konta należności")]
			[Priority(7)]
			public string KontaNaleznosci {
				get { return kontaNaleznosci; }
				set { kontaNaleznosci = value; }
			}*/
			
			string rozdzial = "";
			/*[Caption("Rozdział")]
			[Priority(7)]			
			public string Rozdzial{
				get{ return rozdzial; }
				set{ rozdzial = value; }
			}*/											
			
			string paragraf = "";
			/*[Caption("Paragraf")]
			[Priority(8)]			
			public string Paragraf{
				get{ return paragraf; }
				set{ paragraf = value; }
			}*/

      string zadanie = "";
      /*[Caption("Zadanie")]
      [Priority(9)]
      public string Zadanie
      {
          get { return zadanie; }
          set { zadanie = value; }
      }*/

			string podzadanie = "";
			/*[Caption("Podzadanie")]
			[Priority(10)]
			public string Podzadanie {
				get { return podzadanie; }
				set { podzadanie = value; }
			}	*/				        			
			
			string departament = "";
			/*[Caption("Departament")]
			[Priority(11)]			
			public string Departament{
				get{ return departament; }
				set{ departament = value; }
			}	*/															
    }
</script>
<ea:datacontext id="DataContext1" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="utf-8"?>
<PaczkaSprawozdan Wersja="0.3">
  <Okres>
    <Rok>2009</Rok>
    <TypOkresu>Kwartal</TypOkresu>
    <Okres>1</Okres>
  </Okres>
  <Jednostki>
    <Jednostka>
      <Nazwa>Szkoła Podstawowa</Nazwa>
      <Typ>JB</Typ>
      <Regon>000262266     </Regon>
      <WK>04</WK>
      <PK>11</PK>
      <GK>01</GK>
      <GT>1</GT>
      <PT>0</PT>
      <Sprawozdania>
        <Rb-28s Id="Rb28s_948db767c4e84f9f9cd2034f9707e286">
          <Naglowek>
            <Wersja>0</Wersja>
            <DataSprawozdania>2009-03-10</DataSprawozdania>
          </Naglowek>
          <Pozycje>
            <Pozycja>
              <Dzial>801</Dzial>
              <Rozdzial>80101</Rozdzial>
              <Paragraf>302</Paragraf>
              <P4>0</P4>
              <PL>4900.00</PL>
              <ZA>88.80</ZA>
              <ZO>88.80</ZO>
            </Pozycja>
            <ea:DataRepeater ID="PozycjeDR" runat="server" WithSections="False" OnBeforeRow="PozycjeDR_OnBeforeRow">
            <Pozycja>
            	<ea:XmlDataLabel runat="server" ElementName="Dzial" DataMember="Dzial" XSDType="TZnakowy"></ea:XmlDataLabel>
              <ea:XmlDataLabel runat="server" ElementName="Rozdzial" DataMember="Rozdzial" XSDType="TZnakowy"></ea:XmlDataLabel>
              <ea:XmlDataLabel runat="server" ElementName="Paragraf" DataMember="Paragraf" XSDType="TZnakowy"></ea:XmlDataLabel>
              <ea:XmlDataLabel runat="server" ElementName="P4" DataMember="P4" XSDType="TZnakowy"></ea:XmlDataLabel>
              <ea:XmlDataLabel runat="server" ID="PozycjeDR_PL" ElementName="PL" HideEmptyOrZero="true" DataMember="Plan" XSDType="TKwota2"></ea:XmlDataLabel>
              <ea:XmlDataLabel runat="server" ID="PozycjeDR_ZA" ElementName="ZA" HideEmptyOrZero="true" DataMember="Zaangazowanie" XSDType="TKwota2"></ea:XmlDataLabel>
              <ea:XmlDataLabel runat="server" ID="PozycjeDR_WW" ElementName="WW" HideEmptyOrZero="true" DataMember="Wykonanie" XSDType="TKwota2"></ea:XmlDataLabel>
              <ea:XmlDataLabel runat="server" ID="PozycjeDR_ZO" ElementName="ZO" HideEmptyOrZero="true" DataMember="Zobowiazania" XSDType="TKwota2"></ea:XmlDataLabel>
            </Pozycja>            
            </ea:DataRepeater>
          </Pozycje>
          <DotacjeRozwojowe />
        </Rb-28s>
      </Sprawozdania>
      <Podpisy />
    </Jednostka>
  </Jednostki>
</PaczkaSprawozdan>